/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.Pair;
import de.keksuccino.fancymenu.util.TaskExecutor;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTextPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long FILE_READ_COOLDOWN_MS = 1000L;
    private static final long URL_READ_COOLDOWN_MS = 10000L;
    private static final Map<String, Pair<Long, List<String>>> FILE_CACHE = new ConcurrentHashMap<String, Pair<Long, List<String>>>();
    private static final Set<String> LOADING_SOURCES = Collections.synchronizedSet(new HashSet());

    public FileTextPlaceholder() {
        super("file_text");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        List<String> resultLines;
        List<String> lines;
        String pathOrUrl = dps.values.get("path_or_url");
        String separator = dps.values.get("separator");
        String mode = dps.values.get("mode");
        String lastLinesStr = dps.values.get("last_lines");
        if (pathOrUrl == null || pathOrUrl.isEmpty()) {
            return "";
        }
        if (separator == null) {
            separator = "\\n";
        }
        if (mode == null) {
            mode = "all";
        }
        int lastLines = 1;
        if (lastLinesStr != null) {
            try {
                lastLines = Integer.parseInt(lastLinesStr);
                if (lastLines < 1) {
                    lastLines = 1;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn("[FANCYMENU] Invalid last_lines value: " + lastLinesStr);
            }
        }
        if ((lines = this.getCachedOrLoadAsync(pathOrUrl)) == null || lines.isEmpty()) {
            return "";
        }
        if ("last".equals(mode)) {
            int startIndex = Math.max(0, lines.size() - lastLines);
            resultLines = lines.subList(startIndex, lines.size());
            if (lastLines == 1 && !resultLines.isEmpty()) {
                return resultLines.get(0);
            }
        } else {
            resultLines = lines;
        }
        return String.join((CharSequence)separator, resultLines);
    }

    private List<String> getCachedOrLoadAsync(String path) {
        long cooldownMs;
        Pair<Long, List<String>> cached = FILE_CACHE.get(path);
        long currentTime = System.currentTimeMillis();
        long l = cooldownMs = this.isUrl(path) ? 10000L : 1000L;
        if (cached != null) {
            if (currentTime - cached.getKey() < cooldownMs) {
                return cached.getValue();
            }
            if (!LOADING_SOURCES.contains(path)) {
                this.triggerAsyncLoad(path);
            }
            return cached.getValue();
        }
        if (!LOADING_SOURCES.contains(path)) {
            this.triggerAsyncLoad(path);
        }
        return null;
    }

    private void triggerAsyncLoad(String path) {
        LOADING_SOURCES.add(path);
        TaskExecutor.execute(() -> {
            try {
                List<String> lines = this.isUrl(path) ? this.loadFromUrl(path) : this.loadFromFile(path);
                FILE_CACHE.put(path, Pair.of(System.currentTimeMillis(), lines));
            }
            catch (Exception e) {
                LOGGER.error("[FANCYMENU] Failed to read source asynchronously: " + path, (Throwable)e);
                FILE_CACHE.put(path, Pair.of(System.currentTimeMillis(), new ArrayList()));
            }
            finally {
                LOADING_SOURCES.remove(path);
            }
        }, false);
    }

    private boolean isUrl(String path) {
        return path != null && (path.startsWith("http://") || path.startsWith("https://"));
    }

    private List<String> loadFromUrl(String url) {
        if (!WebUtils.isInternetAvailable()) {
            return new ArrayList<String>();
        }
        InputStream stream = WebUtils.openResourceStream(url);
        if (stream == null) {
            LOGGER.warn("[FANCYMENU] Failed to open URL stream: " + url);
            return new ArrayList<String>();
        }
        return FileUtils.readTextLinesFrom(stream);
    }

    private List<String> loadFromFile(String filePath) throws IOException {
        Path path = Paths.get(filePath = ResourceSource.of(filePath).getSourceWithoutPrefix(), new String[0]);
        if (!Files.exists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
            LOGGER.warn("[FANCYMENU] File not found or is not a regular file: " + filePath);
            return new ArrayList<String>();
        }
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return Arrays.asList("path_or_url", "mode", "separator", "last_lines");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.file_text", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.file_text.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("path_or_url", "/config/fancymenu/assets/some_file.txt");
        values.put("mode", "all");
        values.put("separator", "\\n");
        values.put("last_lines", "1");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

